package server

import (
	"code.justin.tv/esports-exp/centaur/internal/storage"
	centaur "code.justin.tv/esports-exp/centaur/proto"
)

func storageClipsToModelClips(clips []*storage.Clip) []*centaur.Clip {
	//TODO get external clip data
	out := make([]*centaur.Clip, len(clips), len(clips))
	for i, clip := range clips {
		out[i] = &centaur.Clip{
			Id:        clip.ID.String(),
			Slug:      clip.Slug,
			Duration:  clip.Duration,
			Reactions: make([]*centaur.Reaction, len(clip.Reactions), len(clip.Reactions)),
			Type:      string(clip.Type),
		}

		if out[i].Type == "" {
			out[i].Type = string(storage.TwitchClipType)
		}

		for ri, reaction := range clip.Reactions {
			out[i].Reactions[ri] = &centaur.Reaction{
				EmoteId: reaction.EmoteID,
				Amount:  reaction.Amount,
			}
		}
	}
	return out
}
