package server

import (
	"context"

	"code.justin.tv/esports-exp/centaur/internal/storage"
)

func (s *Centaur) getMaxScore(ctx context.Context, user *storage.User, clip *storage.Clip, newScore float64) (float64, error) {
	reactionCnt, err := s.gorm.GetReactionCountForUserClip(user, clip)
	if err != nil {
		return 0, err
	}
	if reactionCnt > 0 {
		return 1, nil
	}

	watched, err := s.gorm.GetUserWatched(user, clip)
	if err != nil {
		return 0, err
	}

	if newScore > 1 {
		newScore = 1
	}

	var watchedDuration int64
	if watched != nil {
		watchedDuration = watched.Duration
	}

	watchedScore := calcWatchedScore(watchedDuration, clip.Duration)
	if watchedScore < newScore {
		return newScore, nil
	}
	return watchedScore, nil
}

func calcWatchedScore(watched, duration int64) float64 {
	if watched < 2 {
		return 0
	}
	return float64(watched) / float64(duration)
}
