package server

import (
	"context"
	"fmt"

	"time"

	"code.justin.tv/esports-exp/centaur/internal/storage"
	centaur "code.justin.tv/esports-exp/centaur/proto"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/s3"
	"github.com/twitchtv/twirp"
)

func (s *Centaur) UploadClip(ctx context.Context, req *centaur.UploadClipRequest) (*centaur.UploadClipResponse, error) {

	if req.Curator == "" {
		return nil, twirp.RequiredArgumentError("curator")
	}

	if req.Broadcaster == "" {
		return nil, twirp.RequiredArgumentError("broadcaster")
	}

	if req.Title == "" {
		return nil, twirp.RequiredArgumentError("title")
	}

	if req.Duration == 0 {
		return nil, twirp.RequiredArgumentError("duration")
	}

	clip := &storage.Clip{
		Type:        storage.ClipClopClipType,
		Curator:     req.Curator,
		Broadcaster: req.Broadcaster,
		Duration:    req.Duration,
		Title:       req.Title,
	}

	if err := s.gorm.SaveClip(clip); err != nil {
		return nil, twirp.NewError(twirp.Internal, fmt.Sprintf("failed to create clip: %s", err.Error()))
	}

	putReq, _ := s.s3.PutObjectRequest(&s3.PutObjectInput{
		Bucket: aws.String("clipclop-clips"),
		Key:    aws.String(clip.ID.String()),
	})
	url, err := putReq.Presign(15 * time.Minute)

	if err != nil {
		return nil, twirp.NewError(twirp.Internal, err.Error())
	}

	return &centaur.UploadClipResponse{
		ClipId: clip.ID.String(),
		Url:    url,
	}, nil
}
