package storage

import (
	centaur "code.justin.tv/esports-exp/centaur/proto"
)

type ClipType string

const (
	TwitchClipType   = "twitch"
	ClipClopClipType = "clip_clop"
)

type Clip struct {
	GormBase

	Type            ClipType
	Slug            string `gorm:"unique_index:slug"`
	Game            string
	Curator         string
	Broadcaster     string
	BroadcasterLogo string
	Title           string
	Views           int64
	VideoURL        string
	ThumbnailURL    string

	Duration int64

	Reactions []Reaction `gorm:"foreignkey:ClipID"`
}

func (clip *Clip) LoadReactions(g *Gorm) error {
	return g.db.Model(&clip).Related(&clip.Reactions).Error
}

func (clip *Clip) ToProto() *centaur.Clip {
	cc := &centaur.Clip{
		Id:                     clip.ID.String(),
		CuratorDisplayName:     clip.Curator,
		BroadcasterDisplayName: clip.Broadcaster,
		Title:                  clip.Title,
		Views:                  clip.Views, //TODO make this include watcheds table
		Slug:                   clip.Slug,
		Duration:               clip.Duration,
		Reactions:              make([]*centaur.Reaction, len(clip.Reactions), len(clip.Reactions)),
		Type:                   string(clip.Type),
		VideoUrl:               clip.VideoURL,
		BroadcasterLogo:        clip.BroadcasterLogo,
		ThumbnailUrl:           clip.ThumbnailURL,
		Game:                   clip.Game,
	}

	if cc.Type == "" {
		cc.Type = string(TwitchClipType)
	}

	for ri, reaction := range clip.Reactions {
		cc.Reactions[ri] = &centaur.Reaction{
			EmoteId: reaction.EmoteID,
			Amount:  reaction.Amount,
		}
	}
	return cc
}
