package storage

import (
	"time"

	"github.com/google/uuid"
	"github.com/jinzhu/gorm"
)

type GormBase struct {
	ID        uuid.UUID  `gorm:"type:uuid;primary_key;" json:"id"`
	CreatedAt time.Time  `json:"created_at"`
	UpdatedAt time.Time  `json:"updated_at"`
	DeletedAt *time.Time `sql:"index" json:"deleted_at"`
}

func (base *GormBase) BeforeCreate(scope *gorm.Scope) error {
	uuid, err := uuid.NewRandom()
	if err != nil {
		return err
	}
	return scope.SetColumn("ID", uuid)
}

type Watched struct {
	GormBase

	Duration int64
	UserID   uuid.UUID `gorm:"unique_index:user_clip_watched"`
	ClipID   uuid.UUID `gorm:"unique_index:user_clip_watched"`

	User *User
	Clip *Clip
}
