package storage

import (
	"github.com/google/uuid"
	"github.com/jinzhu/gorm"
)

type Reaction struct {
	GormBase

	ClipID uuid.UUID
	UserID string

	EmoteID string
	Amount  int64
}

func (r *Reaction) Add(g *Gorm) error {
	return g.db.Set("gorm:insert_option", "ON CONFLICT ON CONSTRAINT emote_id_clip_id_user_id DO UPDATE SET amount = reactions.amount + 1").
		Create(r).
		Error
}

func (g *Gorm) AddReactions(reactions []Reaction) error {
	var err error
	for _, r := range reactions {
		if err != nil {
			return err
		}
		err = r.Add(g)
	}
	return nil
}

func (g *Gorm) GetReactionCountForUserClip(user *User, clip *Clip) (int64, error) {
	var count int64
	err := g.db.Model(&Reaction{}).
		Where(&Reaction{
			UserID: user.ID.String(),
			ClipID: clip.ID,
		}).
		Count(&count).
		Error

	if gorm.IsRecordNotFoundError(err) {
		return 0, nil
	}

	return count, err
}
