package main

import (
	//"bufio"
	"encoding/csv"
	"fmt"
	"io"
	"log"
	"os"
	"strconv"

	"code.justin.tv/esports-exp/centaur/internal/config"
	"code.justin.tv/esports-exp/centaur/internal/redrec"
	"github.com/cheggaaa/pb/v3"
)

func main() {

	csvfile, err := os.Open("train.csv")
	if err != nil {
		log.Fatalln("Couldn't open the csv file", err)
	}

	r := csv.NewReader(csvfile)

	header, err := r.Read()
	if err != nil {
		log.Fatalln("Couldn't read", err)
	}
	fmt.Println("Header: ", header)

	cfg := config.New()
	rr, err := redrec.New(cfg.RedisHost)
	if err != nil {
		panic(fmt.Errorf("failed to setup redrec: %s", err))
	}

	bar := pb.StartNew(1000000)

	// Iterate through the records
	for {
		// Read each record from csv
		record, err := r.Read()
		if err == io.EOF {
			break
		}
		if err != nil {
			log.Fatal(err)
		}

		userID := record[0]
		clipID := record[1]
		duration, err := strconv.ParseFloat(record[3], 64)
		if err != nil {
			log.Fatalln("Couldn't read", err)
		}
		playedDuration, err := strconv.ParseFloat(record[4], 64)
		if err != nil {
			log.Fatalln("Couldn't read", err)
		}

		score := float64(playedDuration) / float64(duration)
		// cap at 1
		if score > 1 {
			score = 1
		}

		// does this help :(
		if score > 0.8 {
			score = 1
		}

		// since user watch is already a positive action we do dis
		score = score/2 + 0.5

		// fmt.Println("Line", userID, clipID, duration, playedDuration, score)

		err = rr.Rate(clipID, userID, score)
		if err != nil {
			log.Fatalf("rate err %s", err)
		}

		bar.Increment()
	}
	bar.Finish()

	fmt.Println("Done")
}
