const CENTAUR_API =
  process.env.REACT_APP_CENTAUR_URL || "http://localhost:8080"

export const GetRecommendation = async (user: string, limit: number) => {
  const data = {
    device_id: user,
    limit: limit,
  };
  const resp = await fetch(`${CENTAUR_API}/twirp/centaur.Centaur/GetClips`, {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify(data),
  });

  return resp.json();
};

export const ReportTimeWatched = async (
  user: string,
  clip: string,
  seconds: number
) => {
  const data = {
    device_id: user,
    clip_id: clip,
    duration: seconds,
  };
  console.log(data)
  const resp = await fetch(
    `${CENTAUR_API}/twirp/centaur.Centaur/ReportTimeWatched`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(data),
    }
  );

  return resp.json();
};

export const AddEmote = async (
  user: string,
  clip: string,
  emote: string
) => {
  const data = {
    device_id: user,
    clip_id: clip,
    emote_id: emote,
  };
  console.log(data)
  const resp = await fetch(
    `${CENTAUR_API}/twirp/centaur.Centaur/AddEmote`,
    {
      method: "POST",
      headers: {
        "Content-Type": "application/json",
      },
      body: JSON.stringify(data),
    }
  );

  return resp.json();
};
