import glob
import os
from pathlib import Path

import pandas as pd
from pyxlsb import open_workbook
import xlrd

data_sheet = 'Post-Mortem Output'


def find_data(excel):
    if os.path.basename(excel).startswith('~'):
        return
    if os.path.splitext(excel)[-1] == '.xlsb':
        df = []
        with open_workbook(excel) as wb:
            for sheetname in wb.sheets:
                if sheetname != data_sheet:
                    continue
                with wb.get_sheet(sheetname) as sheet:
                    for row in sheet.rows():
                        df.append([item.v for item in row])
        df = pd.DataFrame(df[1:], columns=df[0])
        df['Date'] = pd.to_datetime(
            df['Date'].apply(lambda x: xlrd.xldate.xldate_as_datetime(x, 0)))
        return df
    else:
        try:
            df = pd.read_excel(excel, sheet_name=data_sheet)
            return df
        except:
            pass

def deal_import_v2(deal_dir, output_csv):
    excels = glob.glob(os.path.join(deal_dir, '*.xls*'))

    good = []
    bad = []

    dfs = []
    for excel in excels:
        print(f'Processing {excel}')
        try:
            found = ''
            df = find_data(excel)
            if not df is None:
                deal_name = df['Deal Name'].values[0]
                print(f'Found Deal {deal_name}')
                rel_path = os.path.relpath(excel, deal_dir)
                found = excel
                df = df[['Deal Name', 'Type', 'Metric', 'Date', 'Value']]
                df['Source'] = rel_path
                dfs.append(df)
                good.append([deal_name, rel_path, len(df)])
            if not found:
                raise Exception(f"Did not find {data_sheet} in {excel}")
        except Exception as e:
            print(e)
            bad.append([excel, e])
    if dfs:
        all_data = pd.concat(dfs)
        all_data = all_data.sort_values(by=['Deal Name', 'Type', 'Metric', 'Date'])
        all_data.to_csv(output_csv, index=False)
    return good, bad


def deal_import(deal_dir, output_csv):
    deals = glob.glob(os.path.join(deal_dir, '*/'))

    good = []
    bad = []

    dfs = []
    for deal_path in deals:
        deal_name = Path(deal_path).parts[-1]
        print(f'Processing {deal_name}')
        try:
            found = ''
            excels = glob.glob(os.path.join(
                deal_path, 'Analysis', 'Model', '*.xls*'))
            for excel in excels:
                df = find_data(excel)
                if not df is None:
                    rel_path = os.path.relpath(excel, deal_dir)
                    found = excel
                    df = df[['Deal Name', 'Type', 'Metric', 'Date', 'Value']]
                    df['Source'] = rel_path
                    dfs.append(df)
                    good.append([deal_name, rel_path, len(df)])
            if not found:
                raise Exception(f"Did not find {data_sheet} in {excels}")
        except Exception as e:
            print(e)
            bad.append([deal_name, e])
    if dfs:
        all_data = pd.concat(dfs)
        all_data = all_data.sort_values(by=['Deal Name', 'Type', 'Metric', 'Date'])
        all_data.to_csv(output_csv, index=False)
    return good, bad


if __name__ == '__main__':
    good, bad = deal_import(
        '/Users/zihaz/Dropbox (Justin.tv)/Deal Forecast Test', 'deals.csv')
    print(good)
    print(bad)
# pd.read_excel(
