import os
import tkinter as tk
from tkinter import filedialog
from tkinter import messagebox

import deal

root = tk.Tk()
root.withdraw()

deal_dir = filedialog.askdirectory()
output_csv = 'deals.csv'
good, bad = deal.deal_import_v2(deal_dir, output_csv)

errors = "\n\t".join(map(lambda x: ' '.join(map(str, x)), bad))

messagebox.showinfo(f"Import Finished", f"""
{output_csv}

Imported {len(good)} deals from {deal_dir}

Errors: 
\t{errors}
""")
