import type { SignalData } from 'simple-peer';

export enum EventType {
  // client sends these
  Accept = 'accept',
  Call = 'call',
  Join = 'join',
  Leave = 'leave',
  Kick = 'kick',
  // client technically also sends this
  Signal = 'signal',

  // always from server
  Room = 'room',
  Error = 'error',
}

export type ParticipantId = string;

export enum ParticipantConnectionState {
  Connected = 'CONNECTED',
  Alerting = 'ALERTING',
  Pending = 'PENDING',
}

// Participant object
export interface Participant {
  // twitch user_id
  participant_id: ParticipantId;
  // twitch user name
  display_name: string;
  // twitch profile picture
  image_url: string;
  // the unique peer id
  peer_id: string;
  // the connection state
  state: ParticipantConnectionState;
}

// on connect
export interface SocketConnectData {
  query: Omit<Participant, 'state'>;
}

// sent on /signal
export interface Signal {
  type: EventType.Signal;
  // who this goes to / comes from
  peer_id: string;
  // the simple-peer signal data
  signal: SignalData;
}

export type RoomId = string;

// this will be received on the `/room`
export interface Room {
  type: EventType.Room;
  // room id
  room_id: RoomId;
  // room data
  participants: Participant[];
}

// this will be received on the `/error` EventType
export interface Error {
  type: EventType.Error;
  error: Error;
}

export interface Call {
  type: EventType.Call;
  dest: ParticipantId;
}

export interface Join {
  type: EventType.Join;
  room_id: RoomId;
}

export interface Leave {
  type: EventType.Leave;
  room_id: RoomId;
}

export interface Accept {
  type: EventType.Accept;
  participant_id: ParticipantId;
  room_id: RoomId;
}

export interface Kick {
  type: EventType.Kick;
  participant_id: ParticipantId;
  room_id: RoomId;
}
