
const io = require('socket.io-client');
const { v4: uuidv4 } = require('uuid');


describe("callee test", function() {
  it("connect", function(done) {
    const peer_id = uuidv4();
    const peers = new Set([]);
    const user_id = '0fred0';
    let room_id = null;
    const client = io('http://localhost:9000?participant_id=0fred0&display_name=fred&image_url=https%3A%2F%2Fs.gravatar.com%2Favatar%2F311cf4b2771fdce1faa8e0ffbe3e77f1%3Fs%3D80&peer_id=' + peer_id);
    client.on('connect', (socket) => {
      console.log('connected');
      // client.emit('call', { type: 'call', dest: '0john0' });
    });
    client.on('room', (msg) => {
      if (msg == null) {
        done();
        client.close();
        return;
      }
      let me = msg.participants.find((e) => e.participant_id === user_id);
      console.log('room', msg);
      if (!me) {
        return;
      }
      if (me.state === 'ALERTING') {
        client.emit('join', { room_id: msg.room_id });
      } else if (me.state === 'CONNECTED') {
        for (const p of msg.participants) {
          if (p.state === 'CONNECTED'
            && p.participant_id !== user_id
            && !peers.has(p.peer_id)) {
            peers.add(p.peer_id);
            client.emit('signal', {'peer_id': p.peer_id, signal: {sdp: "haha_" + user_id}});
          } else if (p.state === 'PENDING') {
            client.emit('accept', { participant_id:p.participant_id, room_id: msg.room_id });
          }
        }
      }
    });
    client.on('signal', (msg) => {
      console.log('signal');
      // client.emit('me', {participant: {display_name: "#### #### " + user_id + " #### ####"}});
      client.emit('me', {"participant":{"mediaStatus":{"audioOn":false,"videoOn":true}},"type":"me"});
      // client.emit('leave', {room_id: room_id});
    });
  });
});
