#!/bin/bash
set -e
set -x

ENV=${ENV:=dev}
PROJECT=fortwatch

rm ${PROJECT}.zip || true
rm -rf dist
mkdir -p dist

yarn install --dev
yarn pkg fortwatch.js --target node10-win-x64 --output dist/fortwatch.exe

echo ${TAG} > dist/version.txt

zip -r ${PROJECT}.zip -j dist dist/*

python3 -sBc "import hashlib;print(hashlib.sha1(open('${PROJECT}.zip','rb').read()).hexdigest())" > sha1sum.txt

aws s3 cp --acl public-read ${PROJECT}.zip s3://bebo-app/${ENV}/${PROJECT}/latest.zip
aws s3 cp --acl public-read dist/version.txt s3://bebo-app/${ENV}/${PROJECT}/version.txt
aws s3 cp --acl public-read sha1sum.txt s3://bebo-app/${ENV}/${PROJECT}/sha1sum.txt
rm ${PROJECT}.zip || true
