const argv = require("yargs").argv;
const path = require("path");

const getBeboEnvironment = () => {
  if ("ENV" in process.env) {
    return process.env.ENV;
  }
  return "local";
};

var BaseConfig = {
  NAME: "FortWatch",
  WS_PORT: process.env.WS_PORT || argv.port || 3050,
  LOG_LEVEL: 'info'
};

var ProdConfig = Object.assign({}, BaseConfig, {
  LOG_LEVEL: 'info'
});

var PtrConfig = Object.assign({}, ProdConfig, {
});

var DevConfig = Object.assign({}, BaseConfig, {
  LOG_LEVEL: 'debug'
});

var LocalConfig = Object.assign({}, DevConfig, {
  LOG_LEVEL: 'trace'
});

function getConfig() {
  const env = getBeboEnvironment();

  var conf = {};
  switch (env) {
    case "prod":
    case "bebo-prod":
      conf = ProdConfig;
      break;
    case "ptr":
      conf = PtrConfig;
      break;
    case "dev":
      conf = DevConfig;
      break;
    default:
      conf = LocalConfig;
  }
  conf.ENV = env;
  conf.isLocal = function() {
    if (
      conf.env === "prod" ||
      conf.env === "bebo-prod" ||
      conf.env === "dev" ||
      conf.env === "ptr"
    ) {
      return false;
    }
    return true;
  };
  conf.isProd = function() {
    if (conf.env === "prod" || conf.env === "bebo-prod" || conf.env === "ptr") {
      return true;
    }
    return false;
  };
  return conf;
}
module.exports = getConfig();
