const path = require('path');
const Game = require("./game");
const logger = require('../logger');


const PROCESS_NAME = 'r5apex.exe';
const LOG_FILE_PATH = path.join(process.env.PROGRAMDATA, "Origin", "Logs",
                            "Client_Log.txt");


const DATETIME_REGEX = /(\d{4})-(\d{2})-(\d{2}) (\d{2}):(\d{2}):(\d{2})\.(\d{3})/
const TYPE_REGEX = /(SetPresenceMessageHandler::OnMessage)/i;
const JINGLE_REGEX = /(Jingle setting activity to)\s(.*)/i;
const PLAYLIST_TO_MODE_REGEX = /(solo|duo|squad|respawn)s?/i;

class Apex extends Game {
  constructor(onGameStateChange) {
    super({
      gameName: "apex",
      processName: PROCESS_NAME,
      logFilePath: LOG_FILE_PATH,
      onGameStateChange
    })
  }

  parseDTTM(dttm) {
    const g = dttm.match(DATETIME_REGEX);

    if (!g || g.length < 8) {
      return;
    }

    const year = g[1];
    const month = g[2] - 1;
    const day = g[3];
    const hour = g[4];
    const minute = g[4];
    const second = g[5];
    const milli = g[6];
    const timestamp = new Date(
      Date.UTC(year, month, day, hour, minute, second, milli),
    );
    return timestamp;
  }

  onLine(line) {
    if (!line) {
      return;
    }

    const typereg = line.match(TYPE_REGEX);
    if (!typereg || typereg.length < 1) {
      return;
    }

    const dttm = this.parseDTTM(line);
    const type =  typereg[1];

    if (type === 'SetPresenceMessageHandler::OnMessage') {
      this.onPresenceMessage(line);
    }
  }

  onPresenceMessage(message) {
    const m = message.match(JINGLE_REGEX);
    if (!m || m.length < 2) {
      return;
    }

    const status = m[2]; // Apex Legends™;Origin.OFR.50.0002694;INGAME;;;194908;;;Main Menu
    const status_parts = status.split(';');
    const party_state = status_parts[2];
    const mode = status_parts[status_parts.length - 1];

    if (mode.indexOf('Playing') !== -1) {
      if (party_state === 'JOINABLE' || party_state === 'JOINABLE_INVITE_ONLY') {
        const oldGameState = this.currentGameState;
        const mode_parts = mode.split(' on ', 2);
        this.currentPlaylist = this.normalizePlaylist(mode_parts[1]);
        this.currentPlaylistMode = this.parsePlaylistMode(mode);
        this.currentGameState = 'game';
        this.onGameStateChange(oldGameState, this.currentGameState, this.currentGameId);
      } else if (party_state === 'INGAME') {

      }
    } else if (mode === 'Main Menu') {
      this.currentPlaylist = "none";
      this.currentPlaylistMode = "none";
    } else if (mode === 'Lobby') {
      const oldGameState = this.currentGameState;
      this.currentPlaylist = "none";
      this.currentPlaylistMode = "none";
      this.currentGameState = 'lobby';
      this.onGameStateChange(oldGameState, this.currentGameState, this.currentGameId);
    }
  }

  parsePlaylistMode(playlist) {
    const mode_arr = playlist.match(PLAYLIST_TO_MODE_REGEX);
    let newPlaylistMode;
    if (mode_arr) {
      newPlaylistMode = mode_arr[mode_arr.length - 1];
    } else {
      newPlaylistMode = 'none';
    }
    return newPlaylistMode.toLowerCase();
  }

  normalizePlaylist(playlist) {
    return playlist.toLowerCase().replace(' ', '_');
  }

}

module.exports = Apex;
