provider "aws" {
  region = "us-west-2"
  version = "~> 2.44"
}

module "glue-dynamo" {
  source = "git::ssh://git@git.xarth.tv/dp/db-s3-glue.git?ref=34c42e16ee804929050832cbfe6bcc967f04c37c"
  database_type = "dynamodb"
  job_name = "spade-edge-integration-dwe_clients"
  tahoe_producer_name = "spadeclientsdbexport"
  table_config = {
    "spade-edge-integration-dwe_clients" = <<EOF
      {
        "dpu_count": 2,
        "read_ratio": 0.2,
        "version": 0,
        "dynamodb_splits_count": 13,
        "spark_optimization": true,
        "schema": [
          {"name": "lastupdate", "type": "bigint", "output_type": "timestamp"},
          {"name": "lastupdaterfc", "type": "string"},
          {"name": "id", "type": "string", "sensitivity": "userid"},
          {"name": "name", "type": "string"}
          {"name": "localizations", "type": "struct"}
          {"name": "localization_en_us", "type": "string", "is_derived": true}
        ],
        "output_fields": ["lastupdate", "lastupdaterfc", "id", "name", "localization_en_us"]
      }
EOF
  }

  # Struct fields must be unpacked, and convert a millisecond epoch time to a proper timestamp.
  spark_cleaning_code = <<EOF
return (df
  .withColumn('localizations_en_us', df.localizations.getItem('en-us'))
  .withColumn('lastupdate', F.from_unixtime(df.lastupdate / 1000).cast('timestamp'))
)
EOF

  fail_on_error = 1
  s3_output_bucket = "science-exports"
  s3_output_key = "spade-edge-integration-dwe_clients"
  s3_script_bucket = "aws-glue-scripts-673385534282-us-west-2"
  error_sns_topic_name = "glue-export-spade-edge-integration-dwe_clients-error"
  account_number = "673385534282"
  vpc_id = ""
  subnet_id = ""
  availability_zone = ""
  rds_subnet_group = ""
  cluster_username = ""
  db_password_parameter_name = ""
  db_password_key_id = ""
  api_key_parameter_name     = "spadeclientsdbexport-producer-api-key"
  api_key_kms_key_id         = "6043ca4d-151e-4efb-98da-42d2b661d9fb"
}

output "s3_kms_key" {
  value = module.glue-dynamo.s3_kms_key
}

output "s3_output_bucket" {
  value = module.glue-dynamo.s3_output_bucket
}

output "glue_role" {
  value = module.glue-dynamo.glue_role
}
