
resource "aws_s3_bucket_object" "watcher_job_script_dynamodb" {
  count   = var.database_type == "dynamodb" ? 1 : 0
  bucket  = local.computed_s3_script_bucket
  key     = "db_exports/${var.job_name}/watcher.py"
  content = <<EOF

${data.template_file.common_code.rendered}

args = getResolvedOptions(sys.argv, ['ts', 'skip_db_export', 'fail_on_error'])

now, ts = get_ts(args['ts'])
fail_on_error = args['fail_on_error']
logger.info('Going to write to ts %s', ts)
subjob_name = '${element(concat(aws_glue_job.table_export_dynamodb.*.name, list("")), 0)}'

session = boto3.Session(region_name='us-west-2')
glue = patched_glue_client(session)

tahoe_session, producer_api_key = None, None
tahoe_import_id = datetime.datetime.utcnow().strftime('%Y%m%dT%H%M%S.%f')

if '${var.tahoe_producer_name}':
    tahoe_session = get_tahoe_session(session, tahoe_import_id)

    ssm = session.client('ssm', region_name='us-west-2')
    ssm_response = ssm.get_parameter(Name='${var.api_key_parameter_name}', WithDecryption=True)
    producer_api_key = ssm_response['Parameter']['Value']

validate_config(tahoe_session, producer_api_key)

extra_ddb_load_glue_params = {'--fail_on_error': fail_on_error}
process_all_tables(tahoe_import_id, tahoe_session, producer_api_key, int(args['skip_db_export']), extra_ddb_load_glue_params)

EOF
}

