provider "aws" {
  region = var.region
}

resource "aws_sns_topic" "glue_error" {
  name = "glue_error"
}

module "glue_user" {
  source        = "../db-s3-glue"
  database_type = "dynamodb"
  job_name      = "VPCStack-PDX-prod-UserTable-1YYH3RCW8QLE"
  cluster_name  = "VPCStack-PDX-prod-UserTable-1YYH3RCW8QLE"
  table_config = {
    "VPCStack-PDX-prod-UserTable-1YYH3RCW8QLE" = <<EOF
      {
        "tahoe_view_name": "jaskier_referral_users",
        "dpu_count": 2,
        "read_ratio": 0.2,
        "version": 3,
        "schema": [
          {"name": "user_id", "type": "string", "sensitivity": "userid"},
          {"name": "device_id", "type": "string", "sensitivity": "otherid"},
          {"name": "channel_id", "type": "string", "sensitivity": "userid"},
          {"name": "open_at", "type": "string"},
          {"name": "referral_at", "type": "string"},
          {"name": "link_created_at", "type": "string"},
          {"name": "minute_1_at", "type": "string"},
          {"name": "minute_2_at", "type": "string"},
          {"name": "minute_3_at", "type": "string"},
          {"name": "minute_4_at", "type": "string"}
        ]
      }
  EOF
  }
  cleaning_code = <<CODE
def ensure_fields(rec):
    for f, t in schema:
        if f not in rec:
                rec[f] = None
    return rec
return UnnestFrame.apply(Map.apply(frame=frame, f=ensure_fields))
CODE

  error_sns_topic_name    = aws_sns_topic.glue_error.name
  trigger_schedule        = "0 13 * * ? *" # 6am PST Daily
  s3_output_bucket        = "jaskier-db-export"
  s3_output_key           = "jaskier-db-export"
  s3_script_bucket        = "aws-glue-scripts-${data.aws_caller_identity.current.account_id}-${var.region}"
  create_s3_script_bucket = 1
  account_number          = "${data.aws_caller_identity.current.account_id}"
  tahoe_producer_name     = "jaskierdbexport"
  tahoe_producer_role_arn = "arn:aws:iam::331582574546:role/producer-jaskierdbexport"
  api_key_kms_key_id      = "alias/aws/ssm"
  api_key_parameter_name  = "/jaskierdbexport/tahoe_api_key"

  # Unused Fields
  cluster_username           = ""
  vpc_id                     = ""
  subnet_id                  = ""
  availability_zone          = ""
  rds_subnet_group           = ""
  db_password_parameter_name = ""
  db_password_key_id         = ""
}

output "s3_kms_key" {
  value = "${module.glue_user.s3_kms_key}"
}

output "s3_output_bucket" {
  value = "${module.glue_user.s3_output_bucket}"
}

output "glue_role" {
  value = "${module.glue_user.glue_role}"
}
