data "aws_caller_identity" "current" {}
data "aws_availability_zones" "all" {}

data "aws_vpc" "vpc" {
  tags = {
    Name = "VPCStack-PDX-prod VPC"
  }
}

data "aws_subnet" "subnet_private" {
  vpc_id = "${data.aws_vpc.vpc.id}"
  count  = 3

  tags = {
    Name = "VPCStack-PDX-prod Private Subnet - ${element(data.aws_availability_zones.all.names, count.index)}"
  }
}
