package main

import (
	"flag"
	"time"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/esports-exp/marionette/pkg/crawler"
)

func init() {
	log.SetLevel(log.DebugLevel)
}

func main() {
	platformFlag := flag.String("platform", "nimo", "platform: nimo/cube/facebook")
	flag.Parse()

	log.Infof("Crawling %s", *platformFlag)

	c, err := crawler.MakeCrawler(*platformFlag)

	if err != nil {
		log.Errorf("Failed to create crawler: %s", err.Error())
		return
	}

	start := time.Now()

	if err := c.Crawl(); err != nil {
		log.Errorf("Crawling failed %s: %s", c.Platform(), err.Error())
	} else {
		log.Infof("Crawling done %s", c.Platform())
	}

	since := time.Since(start).Seconds()
	log.Infof("Crawling finished %s: %v seconds", c.Platform(), since)
}
