package main

import (
	"fmt"
	"sync"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/esports-exp/marionette/pkg/alert"
	"code.justin.tv/esports-exp/marionette/pkg/cloudwatch"
	"code.justin.tv/esports-exp/marionette/pkg/crawler"
	"github.com/aws/aws-lambda-go/lambda"
)

func Handler() error {
	log.Infof("cralwer invoked")

	crawlers := []crawler.Crawler{}
	for _, platform := range []string{
		// "cube", no longer working
		"dlive",
		// "facebook", run facebook crawler in another lambda since it has different schedule.
		// "mixer", shut down
		"nimo",
		"youtube",
		"booyah",
		"afreeca",
	} {
		crawler, err := crawler.MakeCrawler(platform)
		if err != nil {
			log.Errorf("Failed to create crawler %s: %s", platform, err.Error())
			alert.SendAlert(alert.Alert{
				"Marionette Error",
				fmt.Sprintf("Failed to create crawler %s: %s", platform, err.Error()),
			})
			cloudwatch.SendMetric("CreateCrawlError", 1.0, cloudwatch.UnitCount, platform)
			continue
		}

		crawlers = append(crawlers, crawler)
	}

	wg := sync.WaitGroup{}
	for _, c := range crawlers {
		wg.Add(1)
		go func(c crawler.Crawler) {
			defer wg.Done()
			crawler.Run(c)
		}(c)
	}

	wg.Wait()
	log.Infof("cralwer finished")
	return nil
}

func main() {
	lambda.Start(Handler)
}
