package main

import (
	"fmt"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/esports-exp/marionette/pkg/alert"
	"code.justin.tv/esports-exp/marionette/pkg/cloudwatch"
	"code.justin.tv/esports-exp/marionette/pkg/crawler"
	"github.com/aws/aws-lambda-go/lambda"
)

func FacebookHandler() error {
	log.Info("facebook crawler invoked")

	facebookCrawler, err := crawler.MakeCrawler("facebook")
	if err != nil {
		log.Errorf("Failed to create facebook crawler: %s", err.Error())
		alert.SendAlert(alert.Alert{
			"Marionette Error",
			fmt.Sprintf("Failed to create facebook crawler %s", err.Error()),
		})
		cloudwatch.SendMetric("CreateCrawlError", 1.0, cloudwatch.UnitCount, "facebook")
		return err
	}

	crawler.Run(facebookCrawler)
	return nil
}

func main() {
	lambda.Start(FacebookHandler)
}
