package alert

import (
	"encoding/json"

	log "github.com/sirupsen/logrus"

	"code.justin.tv/esports-exp/marionette/pkg/config"
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/sns"
)

var (
	sess = session.Must(session.NewSessionWithOptions(session.Options{
		SharedConfigState: session.SharedConfigEnable,
	}))
	snsSvc = sns.New(sess)
)

type Alert struct {
	Title string `json:"title"`
	Text  string `json:"text"`
}

func SendAlert(alert Alert) {
	if (config.ENV != "prod" && config.ENV != "dev") ||
		config.ALERT_SNS == "" {
		log.Infof("Alert: %v", alert)
		return
	}
	s, err := json.Marshal(alert)
	if err != nil {
		log.Errorf("Alert failed to marshall: %s", err.Error())
		return
	}

	_, err = snsSvc.Publish(&sns.PublishInput{
		Message:  aws.String(string(s)),
		TopicArn: &config.ALERT_SNS,
	})

	if err != nil {
		log.Errorf("Alert failed to send: %s", err.Error())
		return
	}
}
