package config

import (
	"os"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/session"
	"github.com/aws/aws-sdk-go/service/ssm"
)

// var (
// 	ProxyServerEnabled  = GetEnv("PROXYSERVER_ENABLED", false)
// 	ProxyServerEndpoint = GetEnv("PROXYSERVER_ENDPOINT", "")
// 	ProxyServerRegion   = GetEnv("PROXYSERVER_REGION", "")
// )

var (
	ALERT_SNS     = GetEnv("ALERT_SNS", "")
	ENV           = GetEnv("MARIONETTE_ENV", "")
	DEBUG         = GetEnv("MARIONETTE_DEBUG", "")
	PROXY_ENABLED = GetEnv("PROXYSERVER_ENABLED", "")
)

func GetEnv(key, fallback string) string {
	value := os.Getenv(key)
	if len(value) == 0 {
		return fallback
	}
	return value
}

func GetDBCredentials() (string, string, string, string) {
	env := GetEnv("ENV", "")
	if env == "" {
		return "127.0.0.1", "marionette", "marionette", "marionette"
	}

	sess, err := session.NewSessionWithOptions(session.Options{
		Config:            aws.Config{Region: aws.String("us-west-2")},
		SharedConfigState: session.SharedConfigEnable,
	})
	if err != nil {
		panic(err)
	}

	ssmsvc := ssm.New(sess, aws.NewConfig().WithRegion("us-west-2"))

	host_keyname := aws.String("/marionette/" + env + "/db/host")
	host_params, err := ssmsvc.GetParameter(&ssm.GetParameterInput{
		Name:           host_keyname,
		WithDecryption: aws.Bool(false),
	})

	if err != nil {
		panic(err)
	}
	host := *host_params.Parameter.Value

	username_keyname := aws.String("/marionette/" + env + "/db/username")
	username_params, err := ssmsvc.GetParameter(&ssm.GetParameterInput{
		Name:           username_keyname,
		WithDecryption: aws.Bool(false),
	})

	if err != nil {
		panic(err)
	}
	username := *username_params.Parameter.Value

	password_keyname := aws.String("/marionette/" + env + "/db/password")
	password_params, err := ssmsvc.GetParameter(&ssm.GetParameterInput{
		Name:           password_keyname,
		WithDecryption: aws.Bool(true),
	})
	if err != nil {
		panic(err)
	}

	password := *password_params.Parameter.Value

	name_keyname := aws.String("/marionette/" + env + "/db/name")
	name_params, err := ssmsvc.GetParameter(&ssm.GetParameterInput{
		Name:           name_keyname,
		WithDecryption: aws.Bool(false),
	})
	name := *name_params.Parameter.Value

	if err != nil {
		panic(err)
	}

	return string(host), string(username), string(password), string(name)
}
