package server

import (
	"bufio"
	"context"
	"encoding/base64"
	"net/http"
	"net/http/httputil"
	"strings"
	"time"
)

type Request struct {
	Request string `json:"request"`
}

type Response struct {
	Response string `json:"response"`
}

func HandleRequest(ctx context.Context, req Request) (Response, error) {
	proxyReq, err := http.ReadRequest(bufio.NewReader(strings.NewReader(req.Request)))
	resp := Response{}
	if err != nil {
		return resp, err
	}
	proxyReq.RequestURI = ""
	proxyReq.URL.Scheme = "https"
	proxyReq.URL.Host = proxyReq.Host

	client := &http.Client{Timeout: 5 * time.Second}
	proxyRes, err := client.Do(proxyReq)

	if err != nil {
		return resp, err
	}
	defer proxyRes.Body.Close()
	dump, err := httputil.DumpResponse(proxyRes, true)
	if err != nil {
		return resp, err
	}
	resp.Response = base64.StdEncoding.EncodeToString(dump)
	return resp, nil
}
