package util

import (
	"fmt"
	"math/rand"
)

// Chrome user agents have three fields: OS Version, ChromeVersion.PatchVersion
const chromeUA = "Mozilla/5.0 (%s) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/%s.%d Safari/537.36"

var (
	chromeVersions = []string{
		"76.0.3809",
		"75.0.3770",
		"74.0.3729",
		"73.0.3683",
		"72.0.3626",
		"71.0.3578",
		"70.0.3538",
		"69.0.3497",
		"68.0.3440",
		"67.0.3396",
		"66.0.3359",
		"65.0.3325",
		"64.0.3282",
		"63.0.3239",
		"62.0.3202",
		"61.0.3163",
		"60.0.3112",
		"59.0.3071",
	}
)

var (
	osVersions = []string{
		"Windows NT 10.0",
		"Windows NT 10.0; WOW64",
		"Windows NT 10.0; Win64; x64",
	}
)

func GetRandomUserAgent() string {
	os := osVersions[rand.Intn(len(osVersions))]
	version := chromeVersions[rand.Intn(len(chromeVersions))]
	patch := rand.Intn(100)
	return fmt.Sprintf(chromeUA, os, version, patch)
}

func GetMobileUserAgent() string {
	// TODO: add randomization
	return "Mozilla/5.0 (Linux; Android 6.0; Nexus 5 Build/MRA58N) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/78.0.3904.70 Mobile Safari/537.36"
}
