package util

import (
	"net/http"
	"os"
	"time"

	proxyclient "code.justin.tv/esports-exp/marionette/pkg/proxy/client"
)

func Min(x, y int64) int64 {
	if x < y {
		return x
	}
	return y
}

func ProxyReq(req *http.Request) (*http.Response, error) {
	var resp *http.Response
	var err error
	if os.Getenv("PROXYSERVER_ENABLED") == "true" {
		client := proxyclient.New()
		resp, err = client.Do(req)
	} else {
		client := &http.Client{Timeout: 5 * time.Second}
		resp, err = client.Do(req)
	}
	return resp, err

}
