#!/bin/bash
set -e
set -x

JOB_NAME=marionette
ACCESS_KEY_ID=`$(cat ~/.aws/credentials | grep credential_process | awk -F= '{print $2}' | awk '{$1=$1};1') | jq -r '.AccessKeyId'`
SECRET_ACCESS_KEY=`$(cat ~/.aws/credentials | grep credential_process | awk -F= '{print $2}' | awk '{$1=$1};1') | jq -r '.SecretAccessKey'`
SESSION_TOKEN=`$(cat ~/.aws/credentials | grep credential_process | awk -F= '{print $2}' | awk '{$1=$1};1') | jq -r '.SessionToken'`

docker rm ${JOB_NAME} -f || true
docker build -t ${JOB_NAME}:local --rm .
docker run --rm --name ${JOB_NAME} -e ENV=local -e AWS_ACCESS_KEY_ID=${ACCESS_KEY_ID} -e AWS_SECRET_ACCESS_KEY=${SECRET_ACCESS_KEY} -e AWS_SESSION_TOKEN=${SESSION_TOKEN} ${JOB_NAME}:local
