package main

import (
	"encoding/json"
	"fmt"
	"net/http"
	"net/url"
	"strings"

	proxyclient "code.justin.tv/esports-exp/marionette/pkg/proxy/client"
)

type GameDetail struct {
	IntroductionLang    string `json:"introductionLang"`
	AppLogo             string `json:"appLogo"`
	GameAddr            string `json:"gameAddr"`
	HeadImage           string `json:"headImage"`
	NameLang            string `json:"nameLang"`
	PcLogo              string `json:"pcLogo"`
	RecommendColumnIcon string `json:"recommendColumnIcon"`
	UpdateTime          int    `json:"updateTime"`
	Sort                int    `json:"sort"`
	SwitchStatus        int    `json:"switchStatus"`
	Type                int    `json:"type"`
	MobileGamesIcon     string `json:"mobileGamesIcon"`
	RecommendGameIcon   string `json:"recommendGameIcon"`
	CreateTime          int    `json:"createTime"`
	Name                string `json:"name"`
	ID                  int    `json:"id"`
	BusinessType        int    `json:"businessType"`
	WebHeadImage        string `json:"webHeadImage"`
	Introduction        string `json:"introduction"`
	Status              int    `json:"status"`
}

type GameListResp struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Result struct {
			GameDetailList []GameDetail `json:"gameDetailList"`
		} `json:"result"`
		KeyType int `json:"keyType"`
	} `json:"data"`
}

func main() {

	api := "https://api.nimo.tv/oversea/nimo/api/v2/game/gameListForTable/1033/US/web/b/1/0"

	form := url.Values{
		"keyType": {"0"},
		"body":    {"{\"requestSource\":\"WEB\"}"},
	}

	req, _ := http.NewRequest("POST", api, strings.NewReader(form.Encode()))
	req.Header.Add("Content-Type", "application/x-www-form-urlencoded;charset=UTF-8")

	proxy := proxyclient.New()
	res, _ := proxy.Do(req)
	defer res.Body.Close()

	fmt.Println(res)

	gameListResp := &GameListResp{}
	if err := json.NewDecoder(res.Body).Decode(&gameListResp); err != nil {
		fmt.Printf("cant decode %v\n", err)
	}

	fmt.Println(gameListResp.Data.Result.GameDetailList[0].ID)
	fmt.Println(gameListResp.Data.Result.GameDetailList[0].Name)
}
