package main

import (
	"bufio"
	"io/ioutil"
	"net/http"
	"net/http/httputil"
	"strings"

	"fmt"
	"os"
)

type Request struct {
	Request string `json:"request"`
}

type Response struct {
	Response string `json:"response"`
}

func Do(req *http.Request) (*http.Response, error) {
	dump, _ := httputil.DumpRequestOut(req, true)

	fmt.Println(req.URL)

	fmt.Println(string(dump))

	proxyReq, err := http.ReadRequest(bufio.NewReader(strings.NewReader(string(dump))))

	if err != nil {
		return nil, err
	}

	proxyReq.URL.Scheme = "https"
	proxyReq.URL.Host = proxyReq.Host
	proxyReq.RequestURI = ""

	dump, _ = httputil.DumpRequestOut(proxyReq, true)
	fmt.Println(string(dump))

	// proxyReq.Host =
	proxyRes, err := http.DefaultClient.Do(proxyReq)
	if err != nil {
		return nil, err
	}
	defer proxyRes.Body.Close()
	dump, err = httputil.DumpResponse(proxyRes, true)
	if err != nil {
		return nil, err
	}

	proxyResp, err := http.ReadResponse(bufio.NewReader(strings.NewReader(string(dump))), req)
	if err != nil {
		fmt.Println("Failed to parse response")
		fmt.Println(err)
		os.Exit(0)
	}

	return proxyResp, nil
}

func main() {

	api := "https://api.ipify.org/?format=json"

	req, _ := http.NewRequest("GET", api, strings.NewReader("test"))

	res, err := Do(req)

	if err != nil {
		fmt.Println(err)
		return
	}

	defer res.Body.Close()

	data, _ := ioutil.ReadAll(res.Body)
	fmt.Println((string(data)))
}
