package main

import (
	"bytes"
	"encoding/base64"
	"encoding/json"
	"io/ioutil"
	"log"
	"net/http"
	"net/url"
	"time"
)

type ViewershipData struct {
	ChannelAlias string `json:"channel_alias"`
	ChannelID    string `json:"channel_id"`
	ChannelName  string `json:"channel_name"`
	CountryCode  string `json:"country_code"`
	Game         string `json:"game"`
	Language     string `json:"language"`
	Platform     string `json:"platform"`
	Ccv          int64  `json:"ccv"`
	TimeCrawled  int64  `json:"time_crawled"`
}

// func main() {
// 	log.Println("Creating Spade client")
// 	spadeClient, err := spade.NewClient()
// 	if err != nil {
// 		log.Fatalf("Failed to create Spade client: %v", err)
// 	}

// 	log.Println("Spade client created, submitting Spade event")
// 	err = spadeClient.TrackEvent(
// 		context.Background(),
// 		"spade_testing",
// 		&spadeTesting{
// 			Blob:      "arglebargle",
// 			TestField: "what?",
// 			Num:       2.718281828,
// 			Truthy:    false,
// 			WholeNum:  42,
// 		},
// 	)
// 	if err != nil {
// 		log.Printf("Failed to submit Spade event: %v", err)
// 	}
// }

type spadeEvent struct {
	Event      string         `json:"event"`
	Properties ViewershipData `json:"properties"`
}

func main() {
	// Build up our event, json encode it, and base64 encode it
	event := spadeEvent{
		Event: "marionette_test",
		Properties: ViewershipData{
			ChannelAlias: "ChannelAlias",
			ChannelID:    "ChannelID",
			ChannelName:  "ChannelName",
			CountryCode:  "CountryCode",
			Game:         "Game",
			Language:     "Language",
			Platform:     "Platform",
			Ccv:          100,
			TimeCrawled:  time.Now().Unix(),
		},
	}
	jsonEvent, err := json.Marshal(event)
	if err != nil {
		log.Fatalln("Error in json encoding:", err)
	}
	b64Event := base64.StdEncoding.EncodeToString(jsonEvent)

	api := "https://spade-echo.internal.justin.tv/track"
	// api = "https://spade.twitch.tv"
	// Send it to Spade
	resp, err := http.PostForm(api, url.Values{"data": {b64Event}})
	if err != nil {
		log.Fatalln("Error posting data:", err)
	}
	log.Println("Got status code: ", resp.StatusCode)

	var out bytes.Buffer
	body, err := ioutil.ReadAll(resp.Body)
	json.Indent(&out, body, "", "\t")
	log.Println(string(out.String()))
}
