#!/usr/bin/env node
import cdk = require("@aws-cdk/core");
import { CdkStack } from "../lib/cdk-stack";
import { EcrStack } from "../lib/ecr-stack";

class MarionetteChromeApp extends cdk.App {
  constructor() {
    super();

    new EcrStack(this, "MarionetteChromeECRStack", {
      env: {
        region: "us-west-2"
      }
    });

    new CdkStack(this, "MarionetteChromeStack", {
      env: {
        region: "us-west-2"
      }
    });
  }
}

new MarionetteChromeApp().synth()
