import cdk = require("@aws-cdk/core");
import ecr = require("@aws-cdk/aws-ecr");

export class EcrStack extends cdk.Stack {
  constructor(scope: cdk.App, id: string, props?: cdk.StackProps) {
    super(scope, id, props);

    const repo = new ecr.Repository(this, "MarionetteChromeEcr", {
      repositoryName: "marionette-chrome"
    });

    repo.addLifecycleRule({
      tagStatus: ecr.TagStatus.UNTAGGED,
      maxImageAge: cdk.Duration.days(7)
    });
    repo.addLifecycleRule({ tagStatus: ecr.TagStatus.ANY, maxImageCount: 100 });
  }
}
