import time
import pickle
import json
import base64
import platform
import os
import requests
import humanfriendly
from datetime import datetime
from absl import app, logging, flags
from absl.flags import FLAGS
from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

spade_blueprint = os.environ['SPADE_BLUEPRINT']


def send(events):
    try:
        event_json = json.dumps(events, separators=(',', ':'))
        encoded_event = base64.b64encode(bytes(event_json, 'utf-8'))
        res = requests.post('https://spade.twitch.tv',
                            data={'data': encoded_event})
        if res.status_code != 204:
            logging.error(
                'Spade request failed[%d] %s', res.status_code, res.text)
    except Exception as e:
        logging.exception('Spade send failed')


def scroll(driver):
    page_limit = 20
    page_height = 9999
    page_pause = 0.5

    for i in range(page_limit):
        logging.debug("scrolling %d", i)
        seemore = driver.find_elements_by_xpath(
            "//div[@id='content']//*[contains(text(), 'See More')]")
        loading = driver.find_elements_by_xpath(
            "//div[@id='content']//*[@aria-valuetext='Loading...']")
        if not seemore and not loading:
            logging.debug('break early')
            break
        if loading:
            time.sleep(page_pause)
            continue
        driver.execute_script(f"window.scrollBy(0, {page_height});")
        time.sleep(page_pause)


def main(_):
    config = json.load(open('config.json'))
    email = config['email']
    password = config['password']

    try:
        timestamp = time.time()
        logging.info("Starting Scraping...")

        options = Options()
        options.add_argument("--disable-notifications")
        options.add_argument("--disable-infobars")
        options.add_argument("--mute-audio")
        options.add_argument('--no-sandbox')
        options.add_argument('--disable-dev-shm-usage')

        if not 'Darwin' in platform.system():
            options.add_argument('--headless')

        driver = webdriver.Chrome(options=options)
        driver.get("https://www.facebook.com/")

        try:
            cookies = pickle.load(open("cookies.pkl", "rb"))
            for cookie in cookies:
                if 'expiry' in cookie:
                    del cookie['expiry']
                driver.add_cookie(cookie)
            driver.get("https://www.facebook.com/gaming/?view=directory")
            if driver.find_elements_by_name('email'):
                raise "Not logged in"
        except Exception as e:
            logging.warning("failed to load cookies or login %s", e)
            driver.get("https://www.facebook.com/")
            driver.find_element_by_name('email').send_keys(email)
            driver.find_element_by_name('pass').send_keys(password)
            driver.find_element_by_id('loginbutton').click()
            pickle.dump(driver.get_cookies(), open("cookies.pkl", "wb"))
            driver.get("https://www.facebook.com/gaming/?view=directory")

        logging.info("user logged in")

        scroll(driver)

        games = driver.find_elements_by_xpath(
            "//div[@class='uiScaledImageContainer']")

        logging.info('found %d games', len(games))

        total_viewers = 0
        events = []

        for game in games:
            link = None
            try:
                link = game.find_element_by_xpath("..").get_attribute('href')
                name_div = game.find_elements_by_xpath(
                    "../../..//*[@href='%s']" % link)[1]
                game_name = name_div.text
                ccv = humanfriendly.parse_size(name_div.find_elements_by_xpath(
                    "following-sibling::*")[0].text.split(" ")[0])

                events.append({
                    'event': spade_blueprint,
                    'properties': {
                        'game': game_name,
                        'platform': 'facebook',
                        'ccv': ccv,
                        'time_crawled': int(timestamp)
                    }
                })

                total_viewers += ccv
            except Exception as e:
                logging.exception("failed to fetch game %s", link)

        send(events)

        logging.info("crawled %d channels, total ccv: %d",
                     len(events), total_viewers)

        logging.info("cralwer done in %d seconds", time.time() - timestamp)

        pickle.dump(driver.get_cookies(), open("cookies.pkl", "wb"))
    finally:
        driver.close()


if __name__ == '__main__':
    app.run(main)
