import time
import pickle
import humanfriendly
import collections

from absl import app, logging, flags
from absl.flags import FLAGS

from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait


def main(_):
    try:
        timestamp = time.time()
        email = "project-marionette@protonmail.com"
        password = "marionette@9999"

        logging.info("Starting Scraping...")

        # login(email, password)
        # scrap_profile(ids)
        options = Options()
        options.add_argument("--disable-notifications")
        options.add_argument("--disable-infobars")
        options.add_argument("--mute-audio")
        driver = webdriver.Chrome(options=options)
        driver.get("https://www.facebook.com")

        try:
            cookies = pickle.load(open("cookies.pkl", "rb"))
            for cookie in cookies:
                if 'expiry' in cookie:
                    del cookie['expiry']
                driver.add_cookie(cookie)
            driver.get("https://www.facebook.com/gaming/?view=home")
            if driver.find_elements_by_name('email'):
                raise "Not logged in"
        except Exception as e:
            logging.warning("failed to load cookies or login %s", e)
            driver.get("https://www.facebook.com/")
            driver.find_element_by_name('email').send_keys(email)
            driver.find_element_by_name('pass').send_keys(password)
            driver.find_element_by_id('loginbutton').click()
            pickle.dump(driver.get_cookies(), open("cookies.pkl", "wb"))
            driver.get("https://www.facebook.com/gaming/?view=home")

        logging.info("gaming page loaded")

        see_all_xpath = "//a[contains(text(), 'Live Now')]"
        live_now = WebDriverWait(driver, 10).until(
            EC.element_to_be_clickable((By.XPATH, see_all_xpath)))
        live_now.click()

        logging.info("live page loaded")

        page_limit = 50
        page_height = 9999
        page_pause = 1

        for i in range(page_limit):
            logging.debug("scrolling %d", i)
            driver.execute_script(f"window.scrollBy(0, {page_height});")
            time.sleep(page_pause)

        logging.info("live videos loaded")

        videos = driver.find_elements_by_xpath("//a[@aria-label='video']")

        logging.info("loaded %d videos", len(videos))

        games = collections.defaultdict(int)
        results = []
        total_viewers = 0

        for video in videos:
            try:
                ccv = humanfriendly.parse_size(video.find_elements_by_xpath(
                    "following-sibling::div[2]/div/div[2]")[0].text)
            except Exception as e:
                logging.warning("unable to find ccv %s", e)
                continue

            video_div = video.find_element_by_xpath("../..")
            user_div = video_div.find_elements_by_xpath(".//a[@uid]")[1]

            channel_id = user_div.get_attribute('uid')
            channel_name = user_div.text
            game = video_div.find_elements_by_xpath(
                ".//div[contains(text(), 'playing')]/a")[0].text

            logging.info("%s, %s, %d", channel_name, game, ccv)

            total_viewers += ccv
            results.append((channel_id, channel_name, game, ccv, timestamp))
            games[game] += ccv

        logging.info("crawled %d channels, total ccv: %d",
                     len(results), total_viewers)
        import pprint
        pprint.pprint(games)
        logging.info("cralwer done in %d seconds", time.time() - timestamp)
    finally:
        driver.close()


if __name__ == '__main__':
    app.run(main)
