import time
import pickle
import humanfriendly
import collections

from absl import app, logging, flags
from absl.flags import FLAGS

from selenium import webdriver
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

# logging.set_verbosity(logging.DEBUG)

def scroll(driver):
    page_limit = 20
    page_height = 9999
    page_pause = 0.5

    for i in range(page_limit):
        logging.debug("scrolling %d", i)
        seemore = driver.find_elements_by_xpath("//div[@id='content']//*[contains(text(), 'See More')]")
        loading = driver.find_elements_by_xpath(
            "//div[@id='content']//*[@aria-valuetext='Loading...']")
        if not seemore and not loading:
            logging.debug('break early')
            break
        if loading:
            time.sleep(page_pause)
            continue
        driver.execute_script(f"window.scrollBy(0, {page_height});")
        time.sleep(page_pause)


def crawl_live_page(driver, link, timestamp, results):
    driver.get(link)

    see_all_xpath = "//a[contains(text(), 'Live Now')]"
    live_now = WebDriverWait(driver, 10).until(
        EC.element_to_be_clickable((By.XPATH, see_all_xpath)))
    live_now.click()

    logging.info("live page loaded")

    scroll(driver)

    logging.info("live videos loaded")

    videos = driver.find_elements_by_xpath("//a[@aria-label='video']")

    logging.info("loaded %d videos", len(videos))

    games = collections.defaultdict(int)
    total_viewers = 0

    for video in videos:
        try:
            ccv = humanfriendly.parse_size(video.find_elements_by_xpath(
                "following-sibling::div[2]/div/div[2]")[0].text)
        except Exception as e:
            logging.warning("unable to find ccv %s", e)
            continue

        video_div = video.find_element_by_xpath("../..")
        user_div = video_div.find_elements_by_xpath(".//a[@uid]")[1]

        channel_id = user_div.get_attribute('uid')
        channel_name = user_div.text
        game = video_div.find_elements_by_xpath(
            ".//div[contains(text(), 'playing')]/a")[0].text

        logging.info("%s, %s, %d", channel_name, game, ccv)

        total_viewers += ccv
        results.append((channel_id, channel_name, game, ccv, timestamp))
        games[game] += ccv

    return total_viewers


def main(_):
    try:
        timestamp = time.time()
        logging.info("Starting Scraping...")

        options = Options()
        options.add_argument("--disable-notifications")
        options.add_argument("--disable-infobars")
        options.add_argument("--mute-audio")
        driver = webdriver.Chrome(options=options)

        email = "project-marionette@protonmail.com"
        password = "marionette@9999"
        driver.get("https://www.facebook.com/")
        driver.find_element_by_name('email').send_keys(email)
        driver.find_element_by_name('pass').send_keys(password)
        driver.find_element_by_id('loginbutton').click()
        logging.info("user logged in")

        driver.get("https://www.facebook.com/gaming/?view=directory")
        scroll(driver)

        games = driver.find_elements_by_xpath(
            "//div[@class='uiScaledImageContainer']")
        links = [game.find_element_by_xpath(
            "..").get_attribute('href') for game in games]
        logging.info('found %d games', len(games))

        results = []
        total_viewers = 0

        for link in links:
            total_viewers += crawl_live_page(driver, link, timestamp, results)

        logging.info("crawled %d channels, total ccv: %d",
                     len(results), total_viewers)

        logging.info("cralwer done in %d seconds", time.time() - timestamp)
    finally:
        time.sleep(1000)
        driver.close()


if __name__ == '__main__':
    app.run(main)
