import time
import pickle
import json
import base64
import platform
import os
import requests
import humanfriendly
from datetime import datetime
from absl import app, logging, flags
from absl.flags import FLAGS
from selenium import webdriver
from selenium.common.exceptions import NoSuchElementException
from selenium.webdriver.chrome.options import Options
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as EC
from selenium.webdriver.support.ui import WebDriverWait

spade_blueprint = os.environ['SPADE_BLUEPRINT']


def send(events):
    try:
        event_json = json.dumps(events, separators=(',', ':'))
        encoded_event = base64.b64encode(bytes(event_json, 'utf-8'))
        res = requests.post('https://spade.twitch.tv',
                            data={'data': encoded_event})
        if res.status_code != 204:
            logging.error(
                'Spade request failed[%d] %s', res.status_code, res.text)
    except Exception as e:
        logging.exception('Spade send failed')


def scroll(driver):
    page_limit = 15
    page_height = 2000
    page_pause = 0.5
    driver.execute_script(f"window.scrollBy(0, {page_height});")
    for i in range(page_limit):
        # logging.info("scrolling %d", i)
        # loading = driver.find_elements_by_xpath(
        #     "//c3-infinite-scroll-continuation")
        # if loading:
        #     logging.info('loading?')
        #     time.sleep(page_pause)
        #     continue
        driver.execute_script(f"window.scrollBy(0, {page_height});")
        time.sleep(page_pause)


def main(_):
    try:
        timestamp = time.time()
        logging.info("Starting Scraping...")

        options = Options()
        options.add_argument("--disable-notifications")
        options.add_argument("--disable-infobars")
        options.add_argument("--mute-audio")
        options.add_argument('--no-sandbox')
        options.add_argument('--disable-dev-shm-usage')
        options.add_argument('window-size=375,812')
        options.add_argument(
            'user-agent="Mozilla/5.0 (iPhone; CPU iPhone OS 10_3_1 like Mac OS X) AppleWebKit/603.1.30 (KHTML, like Gecko) Version/10.0 Mobile/14E304 Safari/602.1"')

        if not 'Darwin' in platform.system():
            options.add_argument('--headless')

        driver = webdriver.Chrome(options=options)
        driver.get("https://m.youtube.com/gaming/games")

        logging.info("page opened")

        scroll(driver)

        games = driver.find_elements_by_xpath("//ytm-game-card-renderer")

        logging.info('found %d games', len(games))

        total_viewers = 0
        events = []

        for game in games:
            link = None
            try:
                link = game.find_element_by_xpath("child::a").get_attribute('href')
                name = game.find_element_by_xpath("descendant::h3").text
                try:
                    ccv = humanfriendly.parse_size(
                        game.find_element_by_xpath("descendant::h4").text.split(" ")[0])
                except NoSuchElementException:
                    logging.warning("failed to find ccv for %s", name)
                    ccv = 0

                events.append({
                    'event': spade_blueprint,
                    'properties': {
                        'game': name,
                        'platform': 'youtube',
                        'ccv': ccv,
                        'time_crawled': int(timestamp)
                    }
                })

                total_viewers += ccv
            except Exception:
                logging.exception("failed to fetch game %s", link)

        logging.info("crawled %d channels, total ccv: %d",
                     len(events), total_viewers)

        if events:
            send(events)
        else:
            logging.error("No events found")

        logging.info("cralwer done in %d seconds", time.time() - timestamp)
    finally:
        driver.close()


if __name__ == '__main__':
    app.run(main)
