import time
import sys
from classes import logger as log
from collections import OrderedDict
from threading import Timer


class Animator():

    def __init__(self, session):
        self.session = session
        self.animations = OrderedDict()
        self._timer = None

    def lock(self):
        pass

    def schedule(self, publisher, transition):
        log.info("Animator.schedule %r", transition)
        self.animations[publisher] = {"transition": transition}

    def unlock(self):
        now = time.time()  # FIXME should be using stream time

        for animation in self.animations.values():
            for propname, prop in animation['transition'].items():
                if not prop.get("start"):
                    prop['start'] = now + prop.get("delay", 0) / 1000
                    prop['end'] = prop['start'] + prop.get("duration", 0) / 1000

                if not animation.get('start'):
                    animation['start'] = sys.maxsize
                    animation['end'] = 0
                animation['start'] = min(animation['start'], prop['start'])
                animation['end'] = max(animation['end'], prop['end'])

        self.animations = OrderedDict(sorted(self.animations.items(),
                                             key=lambda a: a[1]['start']))
        self.schedule_next(now)
        return now

    def schedule_next(self, last):
        if self._timer:
            self._timer.cancel()
            self._timer = None
        try:
            _, next_anim = next(iter(self.animations.items()))
            log.debug("%r", next_anim)
            next_start = next_anim['start']
            wait_time = next_start - last
            wait_time = max(wait_time, 0.033)
            log.debug("next animation in %d ms", wait_time * 1000)
            self._timer = Timer(wait_time, self.run_animations)
            self._timer.start()
        except StopIteration:
            pass

    def run_animations(self):
        try:
            log.debug("run_animation")
            # durations are not yet supported...
            # only pop yet
            now = time.time()
            frame = 0.033
            done = []
            for publisher, animation in self.animations.items():
                if animation['start'] > now + frame:
                    log.debug("ignoring %r and all others", animation)
                    break
                for propname, prop in animation['transition'].items():
                    log.debug("%s", propname)
                    if prop['start'] <= now + frame:
                        try:
                            publisher.set_property(propname, prop['target'])
                        except Exception:
                            log.error("error calling set_property: %s %r", propname, prop, exc_info=True)
                            done.append(publisher)
                            break

                if animation['end'] <= now + frame:
                    done.append(publisher)
            for p in done:
                del self.animations[p]

            self.schedule_next(now)
        except Exception:
            log.error("run_animaptions", exc_info=True)

