import datetime
import time
import math
from classes.branches.branch import get_element_base_name

from threading import Timer
from classes import logger as log
from gi.repository import Gst

DEFAULT_INTERVAL_SECONDS = 0.033 # 33ms
_interval = DEFAULT_INTERVAL_SECONDS
_interval_timer = None
_widget_data = {}
_callback = None

SILENT_DB = -350
DEFAULT_LEVEL = {
        'peak_list': [SILENT_DB, SILENT_DB],
        'decay_list': [SILENT_DB, SILENT_DB],
        'rms_list': [SILENT_DB, SILENT_DB]
        }

def set(widget_id, key, peak_list, decay_list, rms_list):
    if widget_id not in _widget_data:
        _widget_data[widget_id] = {}
    _widget_data[widget_id][key] = {
            'peak_list':  peak_list,
            'decay_list': decay_list,
            'rms_list': rms_list
            }

def delete(widget_id):
    if widget_id in _widget_data:
        del _widget_data[widget_id]

def get(widget_id):
    widget_data = _widget_data[widget_id]
    levels = {}
    backward_compatible_level = {}
    for k, v in widget_data.items():
        if k not in levels: # set the default value
            levels[k] = DEFAULT_LEVEL
        levels[k] = {
                'peak_list':  v['peak_list'],
                'decay_list': v['decay_list'],
                'rms_list': v['rms_list']
                }
        if k == 'postprocessed':
            backward_compatible_level = levels[k]
    payload = {
        'url': '/publisher/audiolevel',
        'widget_id': widget_id,
        'peak_list':  backward_compatible_level['peak_list'],
        'decay_list': backward_compatible_level['decay_list'],
        'rms_list': backward_compatible_level['rms_list'],
        'levels': levels
    }

    return payload

def get_all():
    payload_items = []
    for wk, wv in _widget_data.items():
        levels = {}
        backward_compatible_level = {}
        for k, v in wv.items():
            if k not in levels:
                levels[k] = DEFAULT_LEVEL
            levels[k] = {
                'peak_list':  v['peak_list'],
                'decay_list': v['decay_list'],
                'rms_list': v['rms_list']
            }
            if k == 'postprocessed':
                backward_compatible_level = levels[k]
        payload = {
            'url': '/publisher/audiolevel',
            'widget_id': wk,
            'peak_list':  backward_compatible_level['peak_list'],
            'decay_list': backward_compatible_level['decay_list'],
            'rms_list': backward_compatible_level['rms_list'],
            'levels': levels
        }
        payload_items.append(payload)
    return payload_items

def _send_levels():
    global _interval_timer, _callback, _interval
    _interval_timer = Timer(_interval, _send_levels)
    _interval_timer.start()
    if _callback:
        _callback(get_all())

def start(callback, interval=DEFAULT_INTERVAL_SECONDS):
    global _interval_timer, _callback
    if _interval_timer is not None:
        _interval_timer.cancel()
    _callback = callback
    _interval = interval
    _interval_timer = Timer(_interval, _send_levels)
    _interval_timer.start()

def stop():
    global _interval_timer, _callback
    if _interval_timer is not None:
        _interval_timer.cancel()
    _callback = None
