from .filter_branch import FilterBranch
from classes.util import clamp


class AudioVolume(FilterBranch):

    def __init__(self, bus, session_id, widget_id):
        super(AudioVolume, self).__init__(bus, session_id)

        self.volume = self.make('volume')
        self.elements = [self.volume]
        self.add_static_ghost_pads()

    def update(self, volume, visible):
        clamped_volume = clamp(volume, 0, 200)  # min volume: 0% ~ max volume: 200%
        self.volume.set_property('volume', round(clamped_volume / 100, 2))
        is_muted = not visible
        self.volume.set_property('mute', is_muted)  # widget.visible = mute (from the backend)

