from .filter_branch import FilterBranch
from classes import logger as log
from classes import audiolevel_aggregator

SILENT_DB = audiolevel_aggregator.SILENT_DB


class AudioVolumeLevel(FilterBranch):

    def __init__(self, bus, session_id, widget_id, message_type):
        super(AudioVolumeLevel, self).__init__(bus, session_id)

        self.widget_id = widget_id
        hundred_ms = 33 * 1000000
        self.audio_level = self.make("level", "publisher-{}-{}".format(message_type, widget_id),
                                     interval=hundred_ms, peak_falloff=30)
        self.elements = [self.audio_level]
        self.add_static_ghost_pads()

        # self.msg_handle = self.bus.connect("message::state-changed", self.on_state_changed)
        # FIXME - probably only need to subscribe for some kind of messages..
        self.msg_handle = self.bus.connect("message", self.on_message)

    def on_message(self, bus, message):
        mstruct = message.get_structure()
        if message.src is not self.audio_level:
            return

        name = message.src.name[message.src.name.index('-') + 1:]
        message_type = name[:name.index('-')]
        widget_id = name[name.index('-') + 1:]

        if 'audiolevel' in message_type:
            # rms_list would return [NaN, NaN] when no audio sample come through yet
            # and that is not a valid json payload, so we're replacing NaN with 0
            rms_list = [SILENT_DB if x != x else x for x in mstruct.get_value('rms')] if mstruct.has_field('rms') else [SILENT_DB, SILENT_DB]
            peak_list = [SILENT_DB if x != x else x for x in mstruct.get_value('peak')] if mstruct.has_field('peak') else [SILENT_DB, SILENT_DB]
            decay_list = [SILENT_DB if x != x else x for x in mstruct.get_value('decay')] if mstruct.has_field('decay') else [SILENT_DB, SILENT_DB]
            key = message_type.replace('audiolevel_', '')
            audiolevel_aggregator.set(widget_id, key, peak_list, decay_list, rms_list)
        else:
            log.debug('Unknown message level: {}, {}, {}'.format(message_type, message.src, str(message.src)))

    def destroy(self):
        super(AudioVolumeLevel, self).destroy()
        audiolevel_aggregator.delete(self.widget_id)
        if self.msg_handle:
            self.bus.handler_disconnect(self.msg_handle)
