from .src_branch import SrcBranch, LinearSrcBranch
from gi.repository import Gst
import os
from classes import logger as log
from classes.util import make_bebofs_path, make_chrome_cache_path


class Cef(LinearSrcBranch):

    def __init__(self, bus, session_id, url, width, height):
        self.width = min(max(width, 2), 3840)
        self.height = min(max(height, 2), 2160)
        self.url = url
        super(Cef, self).__init__(bus, session_id)
        self.cefsrc = self.make('cef', width=self.width, height=self.height, url=url)

        self.elements = [self.cefsrc]
        self.elements.extend(self.make_glupload_elements(glcolorconvert=True))

        self.link_many(*self.elements)
        self.add_static_ghost_pad()

    def set_url(self, url):
        self.url = url
        log.debug("setting url to %s %r", url, self)
        self.cefsrc.set_property("url", url)

    def __repr__(self):
        return 'CEF, width: {}, height: {}, url: {}'.format(self.width, self.height, self.url)

