from .src_branch import LinearSrcBranch
from gi.repository import Gst
from classes import logger as log


def generate_caps(video_format, width, height, fps, color_format):
    # for whatever reasons, we'd get back video/x-raw, color_format=H264
    caps_string = video_format

    if width is not None:
        caps_string = caps_string + ",width=%d" % width

    if height is not None:
        caps_string = caps_string + ",height=%d" % height

    if fps is not None:
        caps_string = caps_string + ",framerate=%d/1" % fps

    if color_format is not None:
        caps_string = caps_string + ",format=%s" % color_format

    caps = Gst.Caps.from_string(caps_string)
    return caps


class DirectShowVideo(LinearSrcBranch):

    def __init__(self, bus, session_id, device_name, device_path, video_format, width, height, fps, pixel_format, cloned_id=None):

        self.pixel_format = pixel_format
        self.fps = fps
        self.width = width
        self.height = height
        self.device_name = device_name
        self.device_path = device_path

        super(DirectShowVideo, self).__init__(bus, session_id)

        caps = generate_caps(video_format, width, height, fps, pixel_format)
        log.info("DirectShowVideo construct device_name: %s, device_path: %s, caps: %s", device_name, device_path, caps.to_string())
        src = self.make("dshowvideosrc",
                        device_path=device_path,
                        device_name=device_name,
                        do_timestamp=True)
        capsfilter = self.make("capsfilter", caps=caps)

        self.elements = [src, capsfilter]
        if video_format == "image/jpeg":
            queue = self.make_default_queue("dshow_%s" % cloned_id)
            self.elements.append(queue)
            jpeg_dec = self.make("jpegdec", idct_method=1)
            self.elements.append(jpeg_dec)
        elif video_format == "video/x-h264" or pixel_format == "H264":
            queue = self.make_default_queue("dshow_%s" % cloned_id)
            self.elements.append(queue)
            h264_dec = self.make("avdec_h264")
            self.elements.append(h264_dec)

        self.elements.extend(self.make_glupload_elements(glcolorconvert=True))
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

    def __repr__(self):
        return 'DirectShowVideo pixel_fmt: {}, device_name: {}, width: {}, weight: {}, fps: {}'.format(
            self.pixel_format, self.device_name, self.width, self.height, self.fps)

