from .src_branch import LinearSrcBranch
from classes import logger as log
from classes.util import link_many


class DirectSound(LinearSrcBranch):

    def __init__(self, bus, session_id, device_name, device_path, widget_id, is_mono):
        super(DirectSound, self).__init__(bus, session_id)
        log.info("DirectSound - device_name: %s, device_path: %s, is_mono: %d", device_name, device_path, is_mono)

        src = self.make("dshowaudiosrc", device_path=device_path, device_name=device_name)

        # the right hand side (audiomixer) is going to provide the caps that it needs and
        # audioconvert & audioresample will do the job if necessary
        audioconvert = self.make("audioconvert")
        audioresample = self.make("audioresample")
        audio_queue = self.make_audio_device_queue()

        if is_mono:
            channel_mix = self.make('audiochannelmix')
            channel_mix.set_property('left-to-right', 1)
            audioconvert2 = self.make('audioconvert')
            self.elements = [src, audioconvert, channel_mix, audioconvert2,
                             audioresample, audio_queue]
        else:
            self.elements = [src, audioconvert, audioresample, audio_queue]
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

    def need_update(self):
        return False

