from .branch import Branch
from gi.repository import Gst

index = 0


class FakeSink(Branch):
    def __init__(self, bus, session_id):

        super(FakeSink, self).__init__(bus, session_id)

        global index
        index += 1
        self.bin = Gst.Bin.new("fakesink%d" % index)
        fakesink = Gst.ElementFactory.make("fakesink")

        self.bin.add(fakesink)

        sink_pad = fakesink.get_static_pad("sink")
        ghost_sink_pad = Gst.GhostPad.new("sink", sink_pad)
        self.bin.add_pad(ghost_sink_pad)

    def get_sink_pad(self):
        return self.bin.get_static_pad("sink")

    def link_input_branch(self, branch):
        sink_pad = self.bin.get_static_pad("sink")
        src_pad = branch.get_src_pad()
        return src_pad.link(sink_pad)

    def unlink_input_branch(self):
        pass


class GLImageSink(Branch):

    def __init__(self, bus, session_id):

        super(GLImageSink, self).__init__(bus, session_id)

        global index
        index += 1
        self.bin = Gst.Bin.new("fakesink%d" % index)
        fakesink = Gst.ElementFactory.make("glimagesinkelement")
        fakesink.set_property('sync', False)

        self.bin.add(fakesink)

        sink_pad = fakesink.get_static_pad("sink")
        ghost_sink_pad = Gst.GhostPad.new("sink", sink_pad)
        self.bin.add_pad(ghost_sink_pad)

    def get_sink_pad(self):
        return self.bin.get_static_pad("sink")

    def link_input_branch(self, branch):
        sink_pad = self.bin.get_static_pad("sink")
        src_pad = branch.get_src_pad()
        return src_pad.link(sink_pad)

    def unlink_input_branch(self):
        pass

