from classes import logger as log
from .branch import Branch
from gi.repository import Gst


class FilterBranch(Branch):

    def __init__(self, bus, session_id):
        super(FilterBranch, self).__init__(bus, session_id)
        self.input_branch = None
        self.elements = []

    def get_first_sink_pad(self):
        # TODO do we need this on a filter??
        if len(self.elements) > 0:
            return self.elements[1].get_static_pad('sink')
        return self.elements[0].get_static_pad('sink')

    def get_first_src_pad(self):
        return self.elements[0].get_static_pad('src')

    def get_last_sink_pad(self):
        self.elements[-1].get_static_pad("sink")

    def add_static_ghost_pads(self):
        log.debug("add_static_ghost_pads %r", self.elements)
        src_pad = self.elements[-1].get_static_pad('src')
        ghost_src_pad = Gst.GhostPad.new('src', src_pad)
        self.bin.add_pad(ghost_src_pad)

        sink_pad = self.elements[0].get_static_pad('sink')
        ghost_sink_pad = Gst.GhostPad.new('sink', sink_pad)
        self.bin.add_pad(ghost_sink_pad)

    def link_input_branch(self, branch):
        log.debug("link_input_branch %s -> %s", branch, self)
        self.input_branch = branch
        branch_src_pad = branch.get_src_pad()
        branch_src_pad.link(self.get_sink_pad())

