from .src_branch import LinearSrcBranch
from gi.repository import Gst
from classes import logger as log


def generate_caps(width, height, fps):
    caps_string = "video/x-raw(memory:GLMemory)"
    if width is not None:
        caps_string = caps_string + ",width=%d" % width

    if height is not None:
        caps_string = caps_string + ",height=%d" % height

    if fps is not None:
        caps_string = caps_string + ",framerate=%d/1" % fps

    caps = Gst.Caps.from_string(caps_string)
    return caps


class GameCapture(LinearSrcBranch):

    def __init__(self, bus, session_id, width, height, fps, window_name, window_class_name, anti_cheat, inject_dll_path):

        super(GameCapture, self).__init__(bus, session_id)
        log.info("GameCapture - window_name: %s, window_class_name: %s, anti_cheat: %d, dllPath: %s" % (window_name, window_class_name, anti_cheat, inject_dll_path))

        src = self.make("gamecapture")
        src.set_property('do-timestamp', True)
        capsfilter = self.make("capsfilter", caps=generate_caps(width, height, fps))

        if window_name is not None:
            src.set_property("window-name", window_name)
        if window_class_name is not None:
            src.set_property("class-name", window_class_name)
        if anti_cheat is not None:
            src.set_property("anti-cheat", anti_cheat)
        if inject_dll_path is not None:
            src.set_property("inject-dll-path", inject_dll_path)

        queue = self.make_default_queue("game")
        self.elements = [src, capsfilter, queue]
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

