from .filter_branch import FilterBranch
from gi.repository import Gst, GObject
from classes import logger as log

fragment_shader = """
#version 100
#ifdef GL_ES
precision mediump float;
#endif

varying vec2 v_texcoord;

uniform sampler2D tex;
uniform float time;

uniform float redValue_ToBeReplaced;
uniform float greenValue_ToBeReplaced;
uniform float blueValue_ToBeReplaced;


uniform float minHueValue;
uniform float maxHueValue;

uniform float minSaturationValue;
uniform float maxSaturationValue;

uniform float minValueForValue;
uniform float maxValueForValue;

uniform float chromakey;

uniform sampler2D uSampler;

vec3 rgb2hsv(vec3 c)
{
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c)
{
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}


void main () {

    vec4 textureColor = texture2D(uSampler, v_texcoord);


    if(chromakey == 0.0)
    {  //if chromakey is disabled we return the original color for all the fragments aka pixels
        gl_FragColor = textureColor;
    }
    else
    {

    float maskY = float(0.2989) * float(redValue_ToBeReplaced) + float(0.5866) * float(greenValue_ToBeReplaced) + float(0.1145) * float(blueValue_ToBeReplaced);
    float maskCr = float(0.7132) * (float(redValue_ToBeReplaced) - maskY);
    float maskCb = float(0.5647) * (float( blueValue_ToBeReplaced) - maskY);

    float Y = 0.2989 * float(textureColor.r) + float(0.5866) * float(textureColor.g) + float(0.1145) * float(textureColor.b);
    float Cr = 0.7132 * (float(textureColor.r) - Y);
    float Cb = 0.5647 * (float(textureColor.b) - Y);

    float blendValue = smoothstep(minHueValue, maxHueValue + minHueValue, distance(vec2(Cr, Cb), vec2(maskCr, maskCb)));

    gl_FragColor = vec4(textureColor.rgb, textureColor.a * blendValue);
    }
}
"""

index = 0


class GLChroma(FilterBranch):

    def __init__(self, bus, session_id):
        super(GLChroma, self).__init__(bus, session_id)

        global index
        index += 1
        self.bin = Gst.Bin.new("glchroma%d" % index)

        shader = self.make("glshader", fragment=fragment_shader)
        self.shader = shader
        self.elements = [self.shader]
        self.add_static_ghost_pads()

    def update(self, alpha_dict):
        # disable if we pass in None here
        #log.info('new build')
        #log.info(alpha_dict)

        if alpha_dict is None:
            # log.info('alpha_dict is NONE')
            return

        enableChromaKey = 1.0

        if alpha_dict.get("enabled", False) == False:
            # log.info('alpha_dict enabled false')
            enableChromaKey = 0.0
        else:
            # log.info('alpha_dict enabled true')
            enableChromaKey = 1.0

        sensitivityUserValue = alpha_dict.get("white-sensitivity", 0.0)
        noiseUserValue = alpha_dict.get("noise-level", 0.0)
        redBackgroundValue = alpha_dict.get("r", 0.0)
        greenBackgroundValue = alpha_dict.get("g", 0.0)
        blueBackgroundValue = alpha_dict.get("b", 0.0)

        redBackgroundValue = redBackgroundValue / 255.0
        greenBackgroundValue = greenBackgroundValue / 255.0
        blueBackgroundValue = blueBackgroundValue / 255.0

        sensitivityUserValue = sensitivityUserValue;
        noiseUserValue = noiseUserValue;

        thresholdSensitivity = GObject.Value(GObject.TYPE_FLOAT, sensitivityUserValue)
        smoothing = GObject.Value(GObject.TYPE_FLOAT, noiseUserValue)
        redValue_ToBeReplaced = GObject.Value(GObject.TYPE_FLOAT, redBackgroundValue * 1.0)
        greenValue_ToBeReplaced = GObject.Value(GObject.TYPE_FLOAT, greenBackgroundValue * 1.0)
        blueValue_ToBeReplaced = GObject.Value(GObject.TYPE_FLOAT, blueBackgroundValue * 1.0)
        enableChromaKeyShaderValue = GObject.Value(GObject.TYPE_FLOAT, enableChromaKey * 1.0)


        #log.info(thresholdSensitivity)
        #log.info(smoothing)
        #log.info(redValue_ToBeReplaced)
        #log.info(greenValue_ToBeReplaced)
        #log.info(blueValue_ToBeReplaced)
        #log.info(enableChromaKeyShaderValue)


        minSaturationValue = GObject.Value(GObject.TYPE_FLOAT, 100.0)
        maxSaturationValue = GObject.Value(GObject.TYPE_FLOAT, 255.0)

        minValueForValue = GObject.Value(GObject.TYPE_FLOAT, 100.0)
        maxValueForValue = GObject.Value(GObject.TYPE_FLOAT, 255.0)

        uniform_structure = Gst.Structure.new_empty("uniform")

        uniform_structure.set_value("minHueValue", thresholdSensitivity)
        uniform_structure.set_value("maxHueValue", smoothing)

        uniform_structure.set_value("minSaturationValue", minSaturationValue)
        uniform_structure.set_value("maxSaturationValue", maxSaturationValue)

        uniform_structure.set_value("minValueForValue", minValueForValue)
        uniform_structure.set_value("maxValueForValue", maxValueForValue)

        uniform_structure.set_value("redValue_ToBeReplaced", redValue_ToBeReplaced)
        uniform_structure.set_value("greenValue_ToBeReplaced", greenValue_ToBeReplaced)
        uniform_structure.set_value("blueValue_ToBeReplaced", blueValue_ToBeReplaced)

        uniform_structure.set_value("chromakey", enableChromaKeyShaderValue)

        self.shader.set_property("uniforms", uniform_structure)

