from .branch import Branch
import gi
from gi.repository import Gst
from classes.error import LinkError
from classes.util import link_many


class Preview(Branch):

    def __init__(self, bus, session_id, is_dxgi):
        super(Preview, self).__init__(bus, session_id)
        self.input_branch = None

        queue = self.make_queue("queue", max_size_buffers=2, leaky=1)
        elements = [queue]

        if not is_dxgi:
            glvideomixer = self.make("glvideomixerelement", background="black")
            gl2dxgi = self.make("gl2dxgi")
            elements.extend([glvideomixer, gl2dxgi])

        sink = self.make("dshowfiltersink")
        self.sink = sink
        elements.append(sink)

        can_link = link_many(*elements)
        if not can_link:
            raise LinkError("Bebo link error")

        video_sink_pad = elements[0].get_static_pad("sink")
        self.ghost_video_sink_pad = Gst.GhostPad.new("sink", video_sink_pad)
        self.bin.add_pad(self.ghost_video_sink_pad)

    def get_sink_pad(self):
        return self.ghost_video_sink_pad

    def get_latency(self):
        return self.sink.get_property("latency")

