from .src_branch import LinearSrcBranch


class SilentAudio(LinearSrcBranch):

    def __init__(self, bus, session_id, wave):
        super(SilentAudio, self).__init__(bus, session_id)

        audio_src = self.make("audiotestsrc", "dummyaudio")
        audio_src.set_property("wave", wave)
        audio_src.set_property("is-live", True)
        audio_src.set_property("do-timestamp", True)

        audio_queue = self.make_audio_device_queue()

        self.elements = [audio_src, audio_queue]
        self.link_many(*self.elements)
        self.add_static_ghost_pad()

